/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventBuffer;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.sim.animationdp.impl2.VWSIMMemEventReader;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.ListIterator;

class VWSIMMemEventBuffer
implements IVWSIMEventBuffer {
    protected ArrayList m_list = new ArrayList();
    private String m_scenarioId = null;
    protected long m_size = 0L;
    protected static Logger logger = Logger.getLogger("filenet.sim.animationdp.retrieval");
    protected String m_className = "VWSIMMemEventBuffer";
    private int m_status = 0;
    private String m_statusMessage = null;
    private boolean m_finished = false;

    protected String getScenarioId() {
        return this.m_scenarioId;
    }

    public VWSIMMemEventBuffer(String scenarioId) {
        this.m_scenarioId = scenarioId;
        this.m_className = this.m_className + ":";
        this.m_className = this.m_className + this.m_scenarioId;
    }

    public synchronized int log(byte[][] b) throws VWException {
        int nItems = 0;
        if (this.m_finished || b == null) {
            return nItems;
        }
        boolean hasSomething = false;
        try {
            int nCount = b.length;
            for (int i = 0; i < nCount; ++i) {
                AnimationManager[] mgr;
                if (b[i] == null || (mgr = AnimationManager.fromBytes(b[i])).length <= 0 || mgr[0] == null) continue;
                this.m_finished = mgr[0].finished();
                this.m_status = mgr[0].getStatus();
                this.m_statusMessage = mgr[0].getStatusMessage();
                hasSomething = true;
                this.m_list.add(mgr[0]);
                ++this.m_size;
                ++nItems;
            }
            if (hasSomething) {
                this.notifyAll();
            }
        }
        catch (Throwable e) {
            throw new VWException(e);
        }
        return nItems;
    }

    public IVWSIMEventReader getReader() throws VWException {
        return new VWSIMMemEventReader(this);
    }

    public synchronized void markFinished(int status, String statusMessage) {
        this.m_finished = true;
        this.m_status = status;
        this.m_statusMessage = statusMessage;
        this.notifyAll();
    }

    public void releaseResources() {
        this.m_size = 0L;
        this.m_list.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeToFile(String fileName) throws VWException {
        if (!this.m_finished) {
            throw new VWException("filenet.sim.animationdp.impl.FileEventBuffer.writeToFile.notFinished", "Incomplete data transfer.");
        }
        if (this.m_status == 4) {
            throw new VWException("filenet.sim.animation.impl.FileEventBuffer.writeTofFile.invalidData", "Event Buffer contains errors.");
        }
        File destFile = new File(fileName);
        if (destFile.exists()) {
            destFile.delete();
        }
        RandomAccessFile f = null;
        try {
            try {
                f = new RandomAccessFile(destFile, "rwd");
                ListIterator iter = this.m_list.listIterator();
                while (iter.hasNext()) {
                    ((AnimationManager)iter.next()).writeToStream(f);
                }
                Object var6_6 = null;
                if (f == null) return;
            }
            catch (Throwable e) {
                throw new VWException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (f == null) throw throwable;
            try {
                f.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        f.close();
        return;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStatusMessage() {
        return this.m_statusMessage;
    }

    public boolean finished() {
        return this.m_finished;
    }

    protected long getSize() {
        return this.m_size;
    }

    protected ArrayList getList() {
        return this.m_list;
    }
}

